# set parameter values
n = 50
mu = 0.1
lambda = 0.3

# initialise simulation
t_max = 300
Xs = rep(1,n)
p = mean(Xs)
ps = rep(0,t_max+1)
ps[1] = p
 
# main loop
for ( t in 1:t_max )
  {
  # compute colonisation and extinction rates for this
  # timestep
  C = lambda*p/(lambda*p+1)
  E = mu*(1-C)

  # use randomly drawn numbers to determine which patches
  # will change state
  rrr = runif(n)
  old_Xs = Xs  
  Xs[old_Xs==0 & rrr<C] = 1
  Xs[old_Xs==1 & rrr<E] = 0
  
  # recalculate mean patch occupancy and store the result
  p = mean(Xs)
  ps[t+1] = p
  }

plot(0:t_max,ps,type='l',ylim=c(0,1),xlab='t',ylab='p') 
